/*
 * Decompiled with CFR 0.152.
 */
package net.tilialacus.util.tcpproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import net.tilialacus.util.AbstractApplication;
import net.tilialacus.util.Arguments;

public class TcpProxy
extends AbstractApplication {
    public void execute(Arguments args) throws Exception {
        StringTokenizer tokenizer = null;
        String encoding = "iso8859-1";
        if (args.length() == 1) {
            tokenizer = new StringTokenizer(args.get(0), ":");
        } else if (args.length() == 2) {
            tokenizer = new StringTokenizer(args.get(0), ":");
            encoding = args.get(1);
        } else {
            throw new IllegalArgumentException("Incorrect usage");
        }
        this.execute(Integer.parseInt(tokenizer.nextToken()), tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()), encoding);
    }

    public String getUsage() {
        return "localport:host:remoteport [encoding]\nencoding can be iso8859-1, utf-8, or binary. Default iso8859-1";
    }

    public String getHelp() {
        return "Proxies content from one port to another port (possibly on another system) while dumping the content.\nencoding : Encoding to use when dumping content. ISO8859-1, UTF-8, or binary. Default ISO8859-1";
    }

    private void execute(int localPort, String remote, int remotePort, String encoding) throws IOException {
        ServerSocket ss = new ServerSocket(localPort);
        if (remote.length() == 0) {
            remote = "localhost";
        }
        while (true) {
            Socket s1 = ss.accept();
            Socket s2 = new Socket(remote, remotePort);
            new StreamProxy("> ", s1.getInputStream(), s2.getOutputStream(), encoding);
            new StreamProxy("< ", s2.getInputStream(), s1.getOutputStream(), encoding);
        }
    }

    public class StreamProxy
    extends Thread {
        InputStream in;
        OutputStream out;
        String prefix;
        String encoding;

        public StreamProxy(String prefix, InputStream in, OutputStream out, String encoding) {
            this.prefix = prefix;
            this.in = in;
            this.out = out;
            this.encoding = encoding;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] data = new byte[1024];
            try {
                try {
                    int size;
                    while ((size = this.in.read(data)) >= 0) {
                        PrintStream printStream = System.err;
                        synchronized (printStream) {
                            this.out.write(data, 0, size);
                            System.err.print(this.prefix);
                            if ("binary".equals(this.encoding)) {
                                int i = 0;
                                while (i < size) {
                                    System.out.print(String.valueOf(Integer.toHexString(data[i] & 0xFF)) + " ");
                                    ++i;
                                }
                            } else {
                                System.out.println(new String(data, 0, size, this.encoding));
                            }
                            System.out.println();
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    try {
                        this.out.close();
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
            }
        }
    }
}

