/*
 * Decompiled with CFR 0.152.
 */
package net.tilialacus.util.portdump;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import net.tilialacus.util.AbstractApplication;
import net.tilialacus.util.Arguments;

public class PortDump
extends AbstractApplication {
    public void execute(Arguments args) throws Exception {
        if (args.length() == 0) {
            throw new IllegalArgumentException("usage");
        }
        int index = 0;
        int port = Integer.parseInt(args.get(index++));
        int times = args.length() > index ? Integer.parseInt(args.get(index++)) : -1;
        String fileName = args.length() > index ? args.get(index++) : null;
        int delay = args.length() > index ? Integer.parseInt(args.get(index++)) : 0;
        this.execute(port, times, fileName, delay);
    }

    public String getUsage() {
        return "<port> [times [(<file>|-) [<delay>]]]";
    }

    public String getHelp() {
        return "Dumps the data sent over a port.\nport : Port to use.\ntimes : How many times to allow connections to specified port. Default infinate.\nfile : File with respond with. '-' means use STDIN. Default no content.\ndelay : How long to wait before responding in milliseconds. Default 0.";
    }

    public void execute(int port, int times, String fileName, int delay) throws Exception {
        ServerSocket serversocket = null;
        try {
            serversocket = new ServerSocket(port);
            while (times != 0) {
                --times;
                Socket socket = serversocket.accept();
                if (fileName != null) {
                    InputStream sis = "-".equals(fileName) ? System.in : new FileInputStream(fileName);
                    Sender sender = new Sender(socket.getOutputStream(), sis, delay);
                    new Thread(sender).start();
                }
                new Thread(new Fetcher(System.out, socket.getInputStream())).start();
            }
        }
        finally {
            if (serversocket != null) {
                serversocket.close();
            }
        }
    }

    public class Fetcher
    implements Runnable {
        InputStream is;
        OutputStream os;

        public Fetcher(OutputStream os, InputStream is) {
            this.is = is;
            this.os = os;
        }

        public void run() {
            try {
                try {
                    int data;
                    while ((data = this.is.read()) != -1) {
                        this.os.write(data);
                    }
                    this.os.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        this.is.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    this.is.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public class Sender
    implements Runnable {
        InputStream is;
        OutputStream os;
        int delay;

        public Sender(OutputStream os, InputStream is, int delay) {
            this.is = is;
            this.os = os;
            this.delay = delay;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
            try {
                int data;
                while ((data = this.is.read()) != -1) {
                    this.os.write(data);
                }
                this.os.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

