/*
 * Decompiled with CFR 0.152.
 */
package net.tilialacus.util.jwhich;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import net.tilialacus.util.AbstractApplication;
import net.tilialacus.util.Arguments;

public class JWhich
extends AbstractApplication {
    private boolean dispcp = false;
    private boolean showall = false;
    private boolean nosubst = false;

    public String getUsage() {
        return "[-cp] [-all] [-nosubst] resourse";
    }

    public String getHelp() {
        return "This util shows where resources are found in the classpath.\n-cp : Show current classpath.\n-all : Show all occurnaces, not only first.\n-nosubst : Don't try to be smart by replacing '.' with '/' and adding '.class'. Usefull when looking for something else than class files.";
    }

    public void execute(Arguments args) throws Exception {
        if (args.length() == 0) {
            throw new IllegalArgumentException("Incorrect usage");
        }
        int i = 0;
        while (i < args.length()) {
            if (args.get(i).charAt(0) == '-') {
                String argument = args.get(i).toLowerCase();
                if ("-cp".equals(argument)) {
                    this.dispcp = true;
                } else if ("-all".equals(argument)) {
                    this.showall = true;
                } else if ("-nosubst".equals(argument)) {
                    this.nosubst = true;
                } else if ("--help".equals(argument) || "-h".equals(argument)) {
                    throw new IllegalArgumentException("help");
                }
            }
            ++i;
        }
        if (this.dispcp) {
            String classPath;
            String psep = System.getProperty("path.separator");
            String bootClassPath = System.getProperty("sun.boot.class.path");
            if (bootClassPath != null) {
                StringTokenizer tokenizer = new StringTokenizer(bootClassPath, psep);
                System.out.println("Boot classpath:");
                while (tokenizer.hasMoreTokens()) {
                    System.out.println(tokenizer.nextToken());
                }
            }
            if ((classPath = System.getProperty("java.class.path")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(classPath, psep);
                System.out.println("Classpath:");
                while (tokenizer.hasMoreTokens()) {
                    System.out.println(tokenizer.nextToken());
                }
            }
        }
        ClassLoader classloader = ClassLoader.getSystemClassLoader();
        int i2 = 0;
        while (i2 < args.length()) {
            if (args.get(i2).charAt(0) != '-') {
                System.out.println();
                System.out.println(args.get(i2));
                try {
                    URL url;
                    String fclass = this.nosubst ? args.get(i2) : String.valueOf(args.get(i2).replace('.', '/')) + ".class";
                    int locations = 0;
                    if (this.showall) {
                        Enumeration<URL> enumeration = classloader.getResources(fclass);
                        while (enumeration.hasMoreElements()) {
                            url = enumeration.nextElement();
                            if (url == null) continue;
                            ++locations;
                            System.out.println(this.getPath(url, fclass));
                        }
                    } else {
                        url = classloader.getResource(fclass);
                        if (url != null) {
                            ++locations;
                            System.out.println(this.getPath(url, fclass));
                        }
                    }
                    if (locations == 0) {
                        System.out.println("Not found!");
                    }
                }
                catch (IOException ioe) {
                    System.err.println("Classloader failed with: " + ioe.toString());
                }
            }
            ++i2;
        }
    }

    private String getPath(URL url, String cStr) {
        String path = url.getFile();
        String prot = url.getProtocol();
        int start = path.indexOf(58) + 1;
        int end = path.indexOf(cStr);
        if ("jar".equals(prot)) {
            end = path.indexOf(33);
        }
        return path.substring(start, end);
    }

    public static void main(String[] args) throws Exception {
        JWhich jwhich = new JWhich();
        try {
            jwhich.execute(new Arguments(args));
        }
        catch (IllegalArgumentException e) {
            System.err.println(jwhich.getHelp());
            System.err.println(jwhich.getUsage());
        }
    }
}

