/*
 * Decompiled with CFR 0.152.
 */
package net.tilialacus.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import net.tilialacus.util.AbstractApplication;
import net.tilialacus.util.Arguments;

public class Main {
    public static final String RESOURCE = "/net/tilialacus/util/Mappings.properties";

    public static void main(String[] args) throws Exception {
        new Main(args);
    }

    public Main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Must specify the util to run. The following are valid: ");
            Properties props = this.getCommands();
            Iterator<Object> iter = props.keySet().iterator();
            while (iter.hasNext()) {
                System.err.println(iter.next());
            }
            System.err.println("Use: -help <util> to get information about the util.");
            System.exit(2);
        }
        String[] tmpArgs = new String[args.length - 1];
        System.arraycopy(args, 1, tmpArgs, 0, tmpArgs.length);
        Arguments arguments = new Arguments(tmpArgs);
        String cmd = args[0];
        if ("-help".equals(cmd)) {
            AbstractApplication app = this.getApplication(arguments.get(0));
            System.out.println(app.getUsage());
            System.out.println(app.getHelp());
        } else if (tmpArgs.length == 0) {
            AbstractApplication app = this.getApplication(cmd);
            System.out.println(app.getUsage());
            System.out.println(app.getHelp());
        } else {
            AbstractApplication app = this.getApplication(cmd);
            try {
                app.execute(arguments);
            }
            catch (IllegalArgumentException iae) {
                System.err.println(app.getUsage());
                System.err.println(app.getHelp());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Properties getCommands() {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream(RESOURCE));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(3);
        }
        return props;
    }

    public String getImplementation(String name) {
        return this.getCommands().getProperty(name);
    }

    public AbstractApplication getApplication(String name) throws Exception {
        Class<?> clazz = Class.forName(this.getImplementation(name));
        return (AbstractApplication)clazz.newInstance();
    }
}

