/* Copyright (c) 1998 Roger Lindsj */

package se.chalmers.dtek.d97roli.connect4;

import java.awt.event.*;

public class ComputerPlayer{

  public static final int NOVICE = 3;
  public static final int INTERMEDIATE = 5;

  private Arena arena = null;
  public boolean isWorking = false;
  public int maxDepth = INTERMEDIATE;

  private ActionListener actionlistener=null;

  public ComputerPlayer(Arena arena){
    this.arena=arena;
  }

  public void setLevel(int l){
    maxDepth=l;
  }

  // start the min-max at the top of the tree (this actually is max-function with some modifications)
  public void makeBestMove(){
    int maxval=-100000000;
    int bestCol=-1;
    isWorking=true;
    
    for(int i=0; i<arena.width;i++){
      
      if(arena.addToken(i,arena.currentPlayer)>=0){
	// Give other threads a chance to run.
      try{
	Thread.yield();
	Thread.sleep(10);
      }catch(InterruptedException ie){}
      // did we get 4-in-a-row?
	if(((arena.currentPlayer==1)?arena.player1_patterns[arena.player1_patterns.length-1]:
	    arena.player2_patterns[arena.player2_patterns.length-1])>0){
	  maxval=arena.ourScore[arena.ourScore.length-1];
	  bestCol=i;
	  arena.removeLastToken();
	  break;
	}
	// maximize score
	int tmax=min(1, maxval);
	if(tmax>maxval){
	  maxval=tmax;
	  bestCol=i;
	}
	arena.removeLastToken();
      }
    }

    // make best move
    arena.addToken(bestCol, arena.currentPlayer);
    // tell gui that we are done
    isWorking=false;
    if(actionlistener!=null)
      actionlistener.actionPerformed(new ActionEvent(this,0,"Computer done"));
  }

  // maximize the score
  public int max(int depth, int best){
    int maxval=-100000000;
    int bestCol=-1;
    // are we at the bottom of the tree?
    if(depth==maxDepth || arena.movesLeft==0)
      return arena.getValue(arena.currentPlayer);

    // try all columns
    for(int i=0; i<arena.width;i++){
      if(maxval>best)
	break;
      if(arena.addToken(i,arena.currentPlayer)>=0){
	// 4-in-a-row?
	if(((arena.currentPlayer==1)?arena.player1_patterns[arena.player1_patterns.length-1]:
	    arena.player2_patterns[arena.player2_patterns.length-1])>0){
	  maxval=arena.ourScore[arena.ourScore.length-1];
	  bestCol=i;
	  arena.removeLastToken();
	  break;
	}
	// maximize
	int tmax=min(depth+1, maxval);
	if(tmax>maxval){
	  maxval=tmax;
	  bestCol=i;
	}
	arena.removeLastToken();
      }
    }
    // return best score
    if(bestCol!=-1)
      return maxval;
    return 0;
  }

  // minimize
  public int min(int depth, int best){
    int minval=100000000;
    int bestCol=-1;

    // are we at the bottom of the tree?
    if(depth==maxDepth || arena.movesLeft==0)
      return -arena.getValue(arena.currentPlayer);
    // try all columns
    for(int i=0; i<arena.width;i++){
      if(minval<best)
	break;
      if(arena.addToken(i,arena.currentPlayer)>=0){
	// 4-in-a-row?
	if(((arena.currentPlayer==1)?arena.player1_patterns[arena.player1_patterns.length-1]:
	    arena.player2_patterns[arena.player2_patterns.length-1])>0){
	  minval=-arena.ourScore[arena.ourScore.length-1];
	  bestCol=i;
	  arena.removeLastToken();
	  break;
	}
	// minimize
	int tmin=max(depth+1, minval);
	if(tmin<minval){
	  minval=tmin;
	  bestCol=i;
	}
	arena.removeLastToken();
      }
    }
    // return best score
    if(bestCol!=-1)
      return minval;
    return 0;
  }

  // lets other classes listen.
  public void addActionListener(ActionListener al){
    actionlistener=al;
  }
}
