/* Copyright (c) 1998 Roger Lindsj */

package se.chalmers.dtek.d97roli.connect4;

public class Arena{
  protected int[][] tokens;
  
  protected int width;
  protected int height;

  protected int winLength = 4;

  protected int movesLeft=0;

  protected int[] moves;
  
  protected int[] player1_patterns = new int[1<<winLength];
  protected int[] player2_patterns = new int[1<<winLength];
  protected int[] ourScore = new int[1<<winLength];
  protected int[] opponentScore = new int[1<<winLength];

  protected int winLimit;

  // who is playing
  protected int currentPlayer;
  
  public Arena(int height, int width){
    this.width = width;
    this.height = height;
    tokens = new int[height][width];
    reset();
    moves = new int[movesLeft];

    // calculate scoringtable
    for(int i=1; i<ourScore.length; i++){
      int j=i;
      int k=0;
      while(j>0){
	if(j%2==1)
	  k++;
	j=j>>1;
      }
      if(k==winLength)
	ourScore[i]=(int)Math.pow(10,k+1);
      else
	ourScore[i]=(int)Math.pow(10,k-1);
      opponentScore[i]=ourScore[i]>>1;
    }
    winLimit=ourScore[ourScore.length-1]/2;
  }

  // reset board, patterns and player.
  public void reset(){
    movesLeft=width*height;
    for(int i=0; i<height; i++)
      for(int j=0; j<width; j++)
	tokens[i][j] = 0;
    for(int i=0; i<player1_patterns.length; i++){
      player1_patterns[i]=0;
      player2_patterns[i]=0;
    }
    currentPlayer=-1;
  }

  // print all patterns for player1
  public void printPatterns(){
    for(int i=0; i<player1_patterns.length; i++){
      String bt=Integer.toBinaryString(i);
      System.err.println("0000".substring(0,(4-bt.length()))+bt+" "+ player1_patterns[i]);
    }
    System.err.println();
  }

  // try to add a token to column col
  public int addToken(int col, int token){
    int row = height-1;

    while(row>=0 && tokens[row][col]!=0)
      row--;

    // recalculate value
    if(row>=0){
      changePatterns(row,col,-1);
      tokens[row][col]=token;
      changePatterns(row,col,1);
      movesLeft--;
      moves[movesLeft]=col;
      currentPlayer=-currentPlayer;
    }
    return row;
  }

  private int min(int x1, int x2){
    return (x1<x2)?x1:x2;
  }

  private int max(int x1, int x2){
    return (x1>x2)?x1:x2;
  }

  // look for patterns around the point row,col
  private void changePatterns(int row, int col, int dpattern){
    int pattern;
    int scol, srow;
    int totSteps;
    // horizontal
    scol=max(0,col-(winLength-1));
    totSteps=min(width-col, col-scol+1);
    for(int step=0; step<totSteps; step++)
      updatePattern(findPattern(row,scol+step,0,1),dpattern);

    // vertical
    srow=max(0,row-(winLength-1));
    totSteps=min(height-row,row-srow+1);
    for(int step=0; step<totSteps; step++)
      updatePattern(findPattern(srow+step,col,1,0),dpattern);

    // digonal up
    int sdiag=min(min(height-row-1,col),winLength);
    srow=row+sdiag;
    scol=col-sdiag;
    for(int step=0; srow-(winLength-1)-step>=0 && scol+winLength+step-1<width && step<winLength; step++){
      updatePattern(findPattern(srow-step,scol+step,-1,1),dpattern);
    }

    //    digonal down
    sdiag=min(min(row,col),winLength);
    srow=row-sdiag;
    scol=col-sdiag;
    for(int step=0; srow+winLength+step-1<height && scol+winLength+step-1<width && step<winLength; step++){
      updatePattern(findPattern(srow+step,scol+step,1,1),dpattern);
    }
   
  }

  // change the pattern counts
  private void updatePattern(int pattern, int change){
    if(pattern!=0)
      if(pattern<0)
	player1_patterns[-pattern]+=change;
      else
	player2_patterns[pattern]+=change;
  }
  
  // try to match a pattern starting at row, col, moving in drow,dcol direction (winLength long) return the binary value of pattern.
  private int findPattern(int row, int col, int drow, int dcol){
    int pattern=0;
    int token=0;

    for(int i=0; i<winLength; i++){
	pattern*=2;
	if(tokens[row][col]!=0){
	  pattern+=1;
	  if(token==0)
	    token=tokens[row][col];
	  else
	    if(token!=tokens[row][col])
	      return 0; // absolutely no pattern
	}
	row+=drow;
	col+=dcol;
      }

    return pattern * token;
  } 

  // remove last laid token from table
  public void removeLastToken(){
    int row=0;
    int col=moves[movesLeft];
    while(row<height && tokens[row][col]==0)
      row++;

    if(row<height){
      changePatterns(row,col,-1);
      tokens[row][col]=0;
      changePatterns(row,col,1);
      movesLeft++;
      currentPlayer=-currentPlayer;
    }
    // recalculate value
  }

  // get value for board (seen from chosen player) (sum patternscore*nr - other players patterns)
  public int getValue(int token){
    int tot=0;
    for(int i=1; i<ourScore.length;i++)
      if(token==-1){
	tot+=player1_patterns[i]*ourScore[i];
	tot-=player2_patterns[i]*opponentScore[i];
      }else{
	tot+=player2_patterns[i]*ourScore[i];
	tot-=player1_patterns[i]*opponentScore[i];
      }
    return tot;
  }

  // do we have a winner?
  public boolean gotWinner(){
    return player1_patterns[player1_patterns.length-1]+player2_patterns[player2_patterns.length-1]>0;
  }
}
  
